#Ctx_Function ver1.01

#Ctx_Function ver1.02
#25/05/2011
# Adding Count for Function Event4033
# Add "CitrixTools Sessions Cleaner" service in TestingService function

#Ctx_Function ver1.03
#07/06/2011
# Adding Count for every section

#Ctx_Function
#19/09/2014
# Adding Function Ctx_UPMver

Function Get-CustomHTML ($Header) {
$XenAppReport = @"
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/frameset.dtd">
<html><head><title>XenApp_Check  ($($Header))</title>
<META http-equiv=Content-Type content='text/html; charset=windows-1252'>

<meta name="save" content="history">

<style type="text/css">
DIV .expando
{
DISPLAY: block; 
FONT-WEIGHT: normal; 
FONT-SIZE: 10pt; 
RIGHT: 8px; 
COLOR: #ffffff; 
FONT-FAMILY: Tahoma; 
POSITION: absolute; 
TEXT-DECORATION: underline
}

TABLE 
{
TABLE-LAYOUT: fixed; FONT-SIZE: 100%; WIDTH: 100%
}

*{margin:0}

.dspcont 
{ 
BORDER-RIGHT: #bbbbbb 1px solid; 
BORDER-TOP: #bbbbbb 1px solid; 
PADDING-LEFT: 0px; 
FONT-SIZE: 8pt;
MARGIN-BOTTOM: -1px; 
PADDING-BOTTOM: 5px; 
MARGIN-LEFT: 0px; 
BORDER-LEFT: #bbbbbb 1px solid; 

COLOR: #000000; 
MARGIN-RIGHT: 0px; 
PADDING-TOP: 4px; 
BORDER-BOTTOM: #bbbbbb 1px solid; 
FONT-FAMILY: Tahoma; 
POSITION: relative; 
BACKGROUND-COLOR: #f9f9f9
}

.filler 
{
BORDER-RIGHT: medium none; 
BORDER-TOP: medium none; 
DISPLAY: block; 
BACKGROUND: none transparent scroll repeat 0% 0%; 
MARGIN-BOTTOM: -1px; FONT: 100%/8px Tahoma; 
MARGIN-LEFT: 43px; BORDER-LEFT: medium none; 
COLOR: #ffffff; 
MARGIN-RIGHT: 0px; 
PADDING-TOP: 4px; 
BORDER-BOTTOM: medium none; 
POSITION: relative
}
.save{behavior:url(#default#savehistory);}

.dspcont1
{ 
display:none
}


.ombre{
color:#B90000;
font:100px Helvetica;
text-shadow: 0 0px 2px #CC0000,
0 2px 2px #700000,
0 3px 2px #700000,
0 4px 2px #700000,
0 5px 2px #700000,
0 6px 2px #700000,
0 7px 2px #700000,
0 8px 2px #700000,
0 9px 2px #700000,
0 10px 2px #700000,
0 11px 2px #000;
}



a.dsphead0 
{
BORDER-RIGHT: #bbbbbb 1px solid; 
PADDING-RIGHT: 5em; 
BORDER-TOP: #bbbbbb 1px solid; 
DISPLAY: block; 
PADDING-LEFT: 5px; 
FONT-WEIGHT: bold; 
FONT-SIZE: 8pt; 
MARGIN-BOTTOM: -1px; 
MARGIN-LEFT: 0px; 
BORDER-LEFT: #bbbbbb 1px solid; 
CURSOR: hand; COLOR: #FFFFFF; 
MARGIN-RIGHT: 0px; 
PADDING-TOP: 4px; 
BORDER-BOTTOM: #bbbbbb 1px solid; 
FONT-FAMILY: Tahoma; 
POSITION: relative; 
HEIGHT: 2.55em; 
WIDTH: 95%; 
BACKGROUND-COLOR: #149947
}

a.dsphead1
{
BORDER-RIGHT: #bbbbbb 1px solid; 
PADDING-RIGHT: 5em; 
BORDER-TOP: #bbbbbb 1px solid; 
DISPLAY: block; 
PADDING-LEFT: 5px; 
FONT-WEIGHT: bold; 
FONT-SIZE: 8pt; 
MARGIN-BOTTOM: -1px; 
MARGIN-LEFT: 0px; 
BORDER-LEFT: #bbbbbb 1px solid; 
CURSOR: hand; 
COLOR: #ffffff; 
MARGIN-RIGHT: 0px; 
PADDING-TOP: 4px; 
BORDER-BOTTOM: #bbbbbb 1px solid; 
FONT-FAMILY: Tahoma; 
POSITION: relative; 
HEIGHT: 2.55em; 

BACKGROUND-COLOR: #2B75B2
}

a.dsphead2
{
BORDER-RIGHT: #bbbbbb 1px solid; 
PADDING-RIGHT: 5em; 
BORDER-TOP: #bbbbbb 1px solid; 
DISPLAY: block; 
PADDING-LEFT: 5px; 
FONT-WEIGHT: bold; 
FONT-SIZE: 8pt; 
MARGIN-BOTTOM: -1px; 
MARGIN-LEFT: 0px; 
BORDER-LEFT: #bbbbbb 1px solid; 
CURSOR: hand; 
COLOR: #ffffff; 
MARGIN-RIGHT: 0px; 
PADDING-TOP: 4px; 
BORDER-BOTTOM: #bbbbbb 1px solid; 
FONT-FAMILY: Tahoma; 
POSITION: relative; 
HEIGHT: 2.55em; 
WIDTH: 95%; 
BACKGROUND-COLOR: #A5A5A5
}

a.dsphead1 span.dspchar
{
font-family:monospace;font-weight:normal;
}

td 
{
VERTICAL-ALIGN: TOP; 
FONT-FAMILY: Tahoma;
}

th 
{
VERTICAL-ALIGN: TOP; 
COLOR: #000066; 
TEXT-ALIGN: left
}

BODY
{
margin-left: 4pt
} 

BODY
{
margin-right: 4pt
} 

BODY

{
margin-top: 6pt
} 

</style>
</head>
<body>
<b><font face="Arial" size="3">$($Header)</font></b><hr size="4" color='#CCCCCC'>
<font face="Arial" size="1"><b>XenApp_Check $Version generated on $($ENV:Computername)</b></font><br>

<font face="Arial" size="1">Report created on $(Get-Date -format g)</font>
<div class="filler"></div>
<div class="filler"></div>
<div class="filler"></div>
<div class="save">
"@
	Return $XenAppReport
}


Function Get-CustomHeader0 ($Title) {
	$XenAppReport = @"
		<h1><a class="dsphead0">$($Title)</a></h1>
	<div class="filler"></div>
"@
	Return $XenAppReport
}

Function Get-CustomHeader ($Title, $cmnt) {
	$XenAppReport = @"
	<h2><a class="dsphead1">
	$($Title)</a></h2>
	<div class="dspcont">
"@
	Return $XenAppReport
}

Function Get-CustomHeaderClose {
	$XenAppReport = @"
		</DIV>
		<div class="filler"></div>
"@
	Return $XenAppReport
}

Function Get-CustomHeader0Close {
	$XenAppReport = @"
</DIV>
"@
	Return $XenAppReport
}

Function Get-CustomHTMLClose {
	$XenAppReport = @"
</div>

</body>
</html>
"@
	Return $XenAppReport
}

Function Get-HTMLTable {
	param([array]$Content)
	$HTMLTable = $Content | ConvertTo-Html
	$HTMLTable = $HTMLTable -replace '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">', ""
	$HTMLTable = $HTMLTable -replace '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN"  "http://www.w3.org/TR/html4/strict.dtd">', ""
	$HTMLTable = $HTMLTable -replace '<html xmlns="http://www.w3.org/1999/xhtml">', ""
	$HTMLTable = $HTMLTable -replace '<html>', ""
	$HTMLTable = $HTMLTable -replace '<head>', ""
	$HTMLTable = $HTMLTable -replace '<TABLE>', '<TABLE><style>tr:nth-child(even) {background-color: #D8D8D8; TABLE-LAYOUT: Fixed; FONT-SIZE: 100%; WIDTH: 100%}</style>' 
	$HTMLTable = $HTMLTable -replace '</head><body>', ""
	$HTMLTable = $HTMLTable -replace '</body></html>', ""
	$HTMLTable = $HTMLTable -replace '<th>', "<th width=200>"
	Return $HTMLTable
}

Function Get-HTMLDetail ($Heading, $Detail) {
	$XenAppReport = @"
<TABLE>
	<tr>
	<th width='50%'><b>$Heading</b></font></th>
	<td width='50%'>$($Detail)</td>
	</tr>
</TABLE>
"@
Return $XenAppReport
}


Function TestingService {
[HashTable] $OutputEnteteServ = @{}
	if ($WmiError -eq 0)
	{
	$Services_XenApp = ("IMAService","citrix SMA service","MFCom","CtxHttp","cpsvc","CitrixXTEServer","CdmService","CtxActiveSync","CdfSvc","IMAAdvanceSrv","Service de cryptage Citrix","spooler")

		Foreach ($Services_XenApp in $Services_XenApp) 
		{
		$Svc = [System.ServiceProcess.ServiceController]::GetServices($Server) | where{$_.name -eq $Services_XenApp}
			
			if($Svc.status -eq "Stopped") 
			{
			$OutputEnteteServ.TestingServiceTab += @($Server | Select @{N="Server Name";E={$Server.ServerName}}, @{N="Service Stopped";E={$Svc.name}}	) 
			$OutputEnteteServ.TestingServiceCount += 1
			} 
		}
	}
	
Return $OutputEnteteServ
}


Function DiskSpace {
[hashtable] $OutputServDisk = @{}
	if ($WmiError -eq 0)
	{
	$drives = Get-WmiObject -ComputerName $Server Win32_LogicalDisk | Where-Object {$_.DriveType -eq 3} 
		
		foreach($drive in $drives) 
		{
			if (($drive.FreeSpace/1GB) -lt $DiskMin)
			{
			$OutputServDisk.DiskSpaceTab += @($Server | Select @{N="Server Name";E={$Server.ServerName}},
			@{N="Drive";E={($drive.DeviceID)}}, @{N="Free space";E={($drive.FreeSpace/1GB).ToString("0.00")}}, @{N="Total space";E={($drive.size/1GB).ToString("0.00")}}	) 	
			$OutputServDisk.DiskSpaceCount += 1
			}
		}
	}
Return $OutputServDisk
}


Function LogonDisabled {
[hashtable] $OuTputServLogon = @{}

if($Server.LogOnsEnabled -match "False")
{
$OuTputServLogon.LogonDisabledTab += @($Server | Select @{N="Server Name";E={$Server.ServerName}}, @{N="Logon Disabled";E={"TRUE"}} 	) 
$OuTputServLogon.LogonDisabledCount += 1
}
	Return $OuTputServLogon
}


Function Send-SMTPmail($to, $from, $subject, $smtpserver, $body) {
	$mailer = new-object Net.Mail.SMTPclient($smtpserver)
	$msg = new-object Net.Mail.MailMessage($from,$to,$subject,$body)
	$msg.IsBodyHTML = $true
	$mailer.send($msg)
}


Function Event4033 {
[hashtable] $OutputEnteteEvent4033 = @{}
	if ($WmiError -eq 0)
	{
	$Event4003 = (Get-Eventlog system -computer $Server -Newest 500 |  where {$_.EventID -eq 4033}| Where-Object {($_.TimeWritten).Date -eq (Get-Date).Date})

		if($Event4003 -eq $NULL) {} else
		{ 
			Foreach ($line in $Event4003) 
			{
			$OutputEnteteEvent4033.Event4033Tab += @($Server | Select @{N="Server Name";E={$Server.ServerName}}, @{N="Time Generated";E={$line.TimeWritten}}, @{N="Source";E={$line.MEssage}} 	) 
			$OutputEnteteEvent4033.Event4033Count += 1
			}
		}
	}
Return $OutputEnteteEvent4033
}


Function LoadMaintenance {
[Hashtable] $OuTputLoadMaintenance = @{}

$LoadEvalMaint = get-xaloadevaluator -servername $Server

	if ($LoadEvalMaint.LoadEvaluatorName -eq $LoadEval_Check) 
	{
	$OuTputLoadMaintenance.LoadMaintenanceName = $LoadEvalMaint.LoadEvaluatorName
	$OuTputLoadMaintenance.LoadMaintenanceTab += @($Server | Select @{N="Server Name";E={$Server.ServerName}}, @{N="Load Evaluator Name";E={$LoadEvalMaint.LoadEvaluatorName}}	) 
	$OuTputLoadMaintenance.LoadMaintenanceCount += 1
	}
Return $OutputLoadMaintenance
}


Function App_CountServer {
[hashtable] $OuTputApp_Server = @{}

	if (($ApplicationsLine.servernames).count -eq $Null) {}
	ElseIf (($ApplicationsLine.servernames).count -le "1")
	{
	$OuTputApp_Server.App_CountServerTab += @($ApplicationsLine | Select @{N="Application";E={$ApplicationsLine}}, @{N="Folder Path";E={$ApplicationsLine.FolderPath}}, @{N="Number Server";E={($ApplicationsLine.servernames).count}}, @{N="Server Name";E={$ApplicationsLine.servernames}}	) 
	$OuTputApp_Server.App_CountServerCount += 1
	}
	Return $OuTputApp_Server
}


Function App_Disable {
[hashtable] $OuTputApp_Disable = @{}

if ($Applications.enabled -eq $False)
{
$OuTputApp_Disable.App_DisableTab += @($Applications | Select @{N="Application";E={$Applications}}, @{N="Folder Path";E={$Applications.FolderPath}}, @{N="Application Enable";E={$Applications.Enabled}}	) 
$OuTputApp_Disable.App_DisableCount += 1
}
Return $OuTputApp_Disable
}


Function PolicyDisable {
[hashtable] $OutputEntetePolicyDisable = @{}

if ($Policy.Enabled -eq $False)
{
$OutputEntetePolicyDisable.PolicyDisableTab += @($Policy | Select @{N="Policy Name";E={$policy.PolicyName}}, @{N="Policy enable";E={$Policy.Enabled}}	) 
$OutputEntetePolicyDisable.PolicyDisableCount += 1
}

Return $OutputEntetePolicyDisable
}


function GetElapsedTime() {
[hashtable] $TimeToBuild = @{}

$TimeToBuild.runtime = $(get-date) - $scriptStartTime
$TimeToBuild.retStr = [string]::format("{0}:{1}:{2}", `
$TimeToBuild.runtime.Hours, `
$TimeToBuild.runtime.Minutes, `
$TimeToBuild.runtime.Seconds)

Return $TimeToBuild
}


Function Uptime () {
[hashtable] $OutputUptime = @{}
	if ($WmiError -eq 0)
	{
	$lastboottime = (Get-WmiObject -Class Win32_OperatingSystem -computername $Server).LastBootUpTime
	$sysuptime = (Get-Date)  [System.Management.ManagementDateTimeconverter]::ToDateTime($lastboottime)

		if ($sysuptime.days -ge 30)
		{
		$OutputUptime.UptimeTab += @($Server | Select @{N="Server Name";E={$Server.ServerName}}, @{N="Uptime (in days)";E={($sysuptime.days)}}) 
		$OutputUptime.UptimeCount += 1
		#Write-Host "$Server has been up for: " $sysuptime.days "days" $sysuptime.hours "hours" $sysuptime.minutes "minutes" $sysuptime.seconds "seconds"
		}
	}
Return $OutputUptime
}


Function HypervisorType () {
[hashtable] $OutputHypervisorType = @{}
	if ($WmiError -eq 0)
	{
	$comp = Get-WmiObject Win32_ComputerSystem -computername $Server
	$OutputHypervisorType.XenCount = 0
	$OutputHypervisorType.HyperVCount = 0
	$OutputHypervisorType.VmCount = 0
	$OutputHypervisorType.PhysicalCount = 0
	$OutputHypervisorType.ErrorCount = 0

	If ($comp.Manufacturer -eq "Microsoft") {$OutputHypervisorType.HyperVCount += 1}
	ElseIf ($comp.Manufacturer -eq "Microsoft Corporation") {$OutputHypervisorType.HyperVCount += 1} 
	ElseIf ($comp.Manufacturer -like "Vmware*") {$OutputHypervisorType.VmCount += 1}
	ElseIf ($comp.Manufacturer -eq "Xen") {$OutputHypervisorType.XenCount += 1}
	Else {$OutputHypervisorType.PhysicalCount += 1}
	}
Return $OutputHypervisorType
}

Function EdgeSightVersion {
[hashtable] $OutputEdgeSightVer = @{}

	if ($WmiError -eq 0)
	{
		$SysOsType = get-wmiobject win32_computersystem -computer $Server | select-object systemtype
		$SysOsType = $SysOsType.systemtype

		if ($SysOsType -eq "x64-based PC") {$key = "SOFTWARE\Wow6432Node\Citrix\System Monitoring\Agent\EdgeSight\4.00"} else {$key = "SOFTWARE\Citrix\System Monitoring\Agent\EdgeSight\4.00" }

		$HKLM = 2147483650
		$reg = [WMIClass] "\\$Server\root\default:StdRegProv"
		$value = "Version" 
		$EdgeSightAgent = $reg.GetStringValue($HKLM, $key, $value)
		#$EdgeSightAgent = $EdgeSightAgent.sValue

		if ($EdgeSightAgent.sValue -ne $EdgeSightAgentRef) 
		{
		$OutputEdgeSightVer.EdgeSightTab += @($Server | Select @{N="Server";E={$Server.ServerName}}, @{N="Agent version";E={$EdgeSightAgent.sValue}}) 
		$OutputEdgeSightVer.EdgeSightCount +=($countEdgeSiAgentNoOk += 1)
		}
	}

Return $OutputEdgeSightVer
}


Function Ctx_HotFix {
[hashtable] $OutputCtx_Hotfixe = @{}
$Result=""
$Hotfixs = Get-XaServerHotFix -Servername $Server

	If (!$Hotfixs) 
	{
		$OutputCtx_Hotfixe.Ctx_HotFixTab += @($Server | Select @{N="Server";E={$Server.ServerName}}, @{N="Citrix HotFix";E={"LHC error or "+$Ctx_HotFixs+" not Installed"}}) 
		$OutputCtx_Hotfixe.Ctx_HotFixCount += 1
	}
	else
	{
		Foreach ($Hotfix in $Hotfixs)
		{
			if ($HotFix.HotfixName -eq $Ctx_HotFixXA5_32 -or $HotFix.HotfixName -eq $Ctx_HotFixXA5_64)
			{
			$Result="1"
			$CountHotFixe += 1
			}
		}
		
		If ($Result -Ne "1")
		{
		$OutputCtx_Hotfixe.Ctx_HotFixTab += @($Server | Select @{N="Server";E={$Server.ServerName}}, @{N="Citrix HotFix";E={$Ctx_HotFixXA5_32+" or "+$Ctx_HotFixXA5_64}}) 
		$OutputCtx_Hotfixe.Ctx_HotFixCount += 1
		}
	}		
Return $OutputCtx_Hotfixe
}


Function Ctx_SrvLoad {
[hashtable] $OutputCtx_Load = @{}
$SrvLoad = get-XaServerLoad $Server

If ($SrvLoad.load -gt $SrvLoad_Value) 
	{
	$OutputCtx_Load.Ctx_SrvLoadTab += @($Server | Select @{N="Server";E={$Server.ServerName}}, @{N="Load";E={$SrvLoad.Load}}) 
	$OutputCtx_Load.Ctx_SrvLoadCount += 1
	}
	
Return $OutputCtx_Load
}


Function Ctx_UPMver {
[hashtable] $OutputCtx_UPMver = @{}

if ($WmiError -eq 0)
	{
		$HKLM = 2147483650
		$reg = [WMIClass] "\\$Server\root\default:StdRegProv"
		$UPM=$FALSE
		$subkeys = $reg.EnumKey($HKLM, $UPMkey)
				
		ForeAch ($subkey in $subkeys.snames)
		{
		$keyfull = ($UPMkey+$subkey);$PathDisp = $reg.GetStringValue($HKLM, $keyfull, $valueDis)
			If ($PathDisp.svalue -match "Citrix Profile Management") 
			{
			$PathVersion = $reg.GetStringValue($HKLM, $keyfull, $valueVer)
			$PathInstDate = $reg.GetStringValue($HKLM, $keyfull, $valueInstDate)
			$DateInstall= ([datetime]::ParseExact($PathInstDate.svalue,yyyyMMdd,$null)).toshortdatestring()
			
				If ($PathVersion.svalue -ne $UPMVer)
				{
				$OutputCtx_UPMver.Ctx_UPMVertab +=  @($Server | Select @{n="Server(s)";e={$Server}},@{n="UPM Version";e={$PathVersion.svalue}},@{n="Install Date";e={$DateInstall}})
				$OutputCtx_UPMver.Ctx_UPMCount += 1
				}
				$UPM=$TRUE
			}
		}
		If ($UPM -eq $FALSE) {$OutputCtx_UPMver.Ctx_UPMCount += 1;$OutputCtx_UPMver.Ctx_UPMVerTab +=  @($Server | Select @{n="Server(s)";e={$Server}},@{n="UPM Version";e={"UPM not installed"}})}
			
	}

Return $OutputCtx_UPMver
}