#XenApp_Check
#CTXBLOG.fr

#Version : 1.0
#21/03/  

#Version : 1.01
#07/05/2011
#Adding Server(s) Off line section (server name, zone and folder path)

#Version : 1.02
#13/05/2011
#Adding variable $AppFolderExclude and $ServFolderExclude for Filter (exclude) Folder and Server

#Version : 1.03
#13/05/211
#Adding Count for Event4033 section

#Version : 1.1
#27/05/2011
#Adding Count for every section

#Version : 1.2
#21/10/2011
#Adding enable or disable check (#Check function) except Off Line Server Section
#Adding variable $AppName for Filter (exclude) Application

#Version : 1.5
#05/09/2012
#Adding "Cmdlet Execution Time" Section (by default this section are disabled, enabled this section by $Check_CmdletExecutionTime = "TRUE" in check function)
#Adding Uptime section (by default uptime = $sysuptime.days -ge 30), configure your uptime in Ctx_functions.ps1 (Function Uptime)
#Fix table bug
#coloring even lines by CSS3 (thx Vmdude) with "tr:nth-child(even)"

#Version : 1.6
#06/12/2012
#Adding "Server(s) type" section (physical, vm, xen or hyperV
#Fix bugs
#Add $Uptime = "30" (before this variable as set in Ctx_FunctionsXA6.ps1)
#Add  =>$Uptime day(s) : in uptime section
#Add Domain in General Dtail section
#Add Licence server TS/RDS in General Dtail section
#Check OS architecture

#Version : 2.0
#11/12/2012
#Add "Split-Path -Parent $MyInvocation.MyCommand.Path" for Check directory script run
#Modify path function file ". "\\your share\XenApp_Check\Ctx_Functions.ps1" by ". $Path'Ctx_FunctionsXA6.ps1' "
#Add create backup folder if not exist on $Path
#Add check WMI error on Foreach ($Servers in $Servers) for reduce time execution XenApp_Check

#Version : 2.1
#20/01/2013
#Add Log folder (henceforth the html file is located in .\Log folder)
#Add display server in console (yellow start check, green end check)
#Adding "EdgeSight Version" Section

#Version : 2.2
#15/04/2013
#Add HotFix section

#Version : 2.3
#29/04/2013
#Add Load Server section

#16/07/2013
#Fix bugs

#Version : 2.5
#13/08/2014
#Optimize check WMI
#Add UPM section
#Add Section statut

#Set-executionpolicy RemoteSigned
If ((Get-PSSnapin -Name "Citrix*" -ErrorAction SilentlyContinue | Measure-Object).count -eq 0) {Add-PSSnapin -Name "Citrix*"}

#XenApp_Check version
$Version = "2.5"

$host.ui.RawUI.WindowTitle = ("XenApp_Check v"+$Version)
.
clear
Write-host "XenApp_Check is started" -ForegroundColor  yellow `n

#Gets the farm information
$farm = Get-XAFarm
$farmConf = Get-XAFarmConfiguration
Write-host "GET-XAFarm done"

#--------------------------------------#
#          Global Variables            #
#--------------------------------------#
#Time variable
$Date = Get-Date
#Domain
$Domain = $env:USERDNSDOMAIN
#OS architecture
if([IntPtr]::Size -eq 4){$OSarchi = "32"} Else {$OSarchi = "64"}
#Uptime
$Uptime = "30"
#XenApp_Check Disk
$DiskMin = "1.0"
#Load Evaluator
$LoadEval_Check = "LE_MAINTENANCE"
#EdgeSight Agent version
$EdgeSightAgentRef = "5.3.4136.3"
#HotFixes XenApp 
$Ctx_HotFixXA5_32 = "PSE450W2K3R07"
$Ctx_HotFixXA5_64 = "PSE450W2K3X64R07"
$SrvLoad_Value = "9998"
#UPM variables
$UPMVer="5.0.0.111"
$UPMkey = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\"
$valueDis = "DisplayName"
$valueVer = "DisplayVersion"
$valueInstDate="InstallDate"
#WMI TCP Port
$TcpPort="135"

#  this code will test if this dll is loaded allready and else load it
if (-not ([appdomain]::CurrentDomain.getassemblies() |? {$_.ManifestModule -like "system.serviceprocess"})) {[void][System.Reflection.Assembly]::LoadWithPartialName('system.serviceprocess')}

# Turn off Errors
#$ErrorActionPreference = "silentlycontinue"

# Set the SMTP Server address
$SMTPSRV = "your-smtp.fr"
# Set the Email address to recieve from
$EmailFrom = "email-from@ctxblog.fr"
# Set the Email address to send the email to
$EmailTo = "YourAdress@ctxblog.fr"



#Create html report
$Path = Split-Path -Parent $MyInvocation.MyCommand.Path #Check directory script run
$Path = $Path + "\"
$FileName="XenApp_Check-" + $farm
$PathBackup=$Path + "Backup\"
$PathLog=$Path + "Log\"
if ((Test-Path -path $PathBackup) -ne $True) {New-Item $PathBackup -type directory}
if ((Test-Path -path $PathLog) -ne $True) {New-Item $PathLog -type directory}

#File functions
. $Path"Ctx_FunctionsXA5.ps1"


#Variables XenApp_Check
#Zone(s) variable
$scriptStartTime = get-date
$Zones = GET-XAZone | sort ZoneName
$Zones_Count = (($Zones | Measure-Object).Count)
$OnlineServers = (($Zones| Get-XAServer -OnlineOnly | Sort-Object ServerName))
$ExecutionTimeXaZone= GetElapsedTime
Write-host "GET-XAZone done"

#LoaEvaluator variables
$scriptStartTime = get-date
$LoadEvaluator = GET-XALoadEvaluator | sort LoadEvaluatorName
$LoadEvalutaror_Count = (($LoadEvaluator | Measure-Object).Count)
$ExecutionTimeXALE= GetElapsedTime
Write-host "GET-XALoadEvaluator"

#Policy Variable
$scriptStartTime = get-date
$Policy = GET-XAPolicy | sort Priority
$Policy_Count = (($Policy | Measure-Object).Count)
$ExecutionTimePolicy= GetElapsedTime
Write-host "GET-XAPolicy done"

#Administrator variable
$scriptStartTime = get-date
$Adm = Get-XAAdministrator
$Adm_Count = (($Adm | Measure-Object).Count)
$ExecutionTimeXAAdministrator= GetElapsedTime
Write-host "Get-XAAdministrator done"

#Applications variable
$scriptStartTime = get-date
$Applications = Get-XAApplicationReport *
$Applications_Count = (($Applications | Measure-Object).Count)
$ExecutionTimeXAApplicationReport= GetElapsedTime
Write-host "Get-XAApplicationReport * done"


#Servers variable
$scriptStartTime = get-date
$Servers = Get-XAServer	| sort FolderPath 
$Servers_Count = (($Servers | Measure-Object).Count)
$AllServers = (($Servers | Select-Object ServerName | Sort-Object ServerName))
$ExecutionTimeXAServer= GetElapsedTime
Write-host "Get-XAServer done" `n

#Filter folder and AppName
$AppFolderExclude = "AppFolder1", "AppFolder2"
$AppNameExclude = "App1", "App2"
$ServFolderExclude = "SrvFolder1", "SrvFolder1"

#Check function (FALSE=Disable - TRUE=Enabled)
$Check_DisplaySection = "TRUE"
$Check_GeneralDetails = "TRUE"
$Check_DsCheckReport = "TRUE"
$Check_CmdletExecutionTime = "FALSE"
$Check_OutputEnteteZone = "TRUE"
$Check_OutputEntetePolicyDisable = "TRUE"
$Check_VarFunctionEvent4033 = "TRUE"
$Check_VarOutputEnteteServ = "TRUE"
$Check_VarOutputServDisk = "TRUE"
$Check_VarOuTputServLogon = "TRUE"
$Check_VarOuTputLoadMaintenance = "TRUE"
$Check_VarFunctionApp_CountServers = "TRUE"
$Check_VarFunctionApp_Disable = "TRUE"
$Check_VarUptime = "TRUE"
$Check_VarTypeSrv = "TRUE"
$Check_EdgeSightAgentVer = "FALSE"
$Check_Ctx_HotFix = "TRUE"
$Check_Ctx_SrvLoad = "TRUE"
$Check_Ctx_UPMver = "TRUE"


#Farm Name
$XenAppReport = Get-CustomHTML "Farm Name : $Farm"
$XenAppReport += Get-CustomHeaderClose


#Read dns file
If ($OSarchi -eq "32") {$DsnPath = "C:\Program Files\Citrix\Independent Management Architecture\mf20.dsn"} else {$DsnPath = "C:\Program Files (x86)\Citrix\Independent Management architecture\mf20.dsn"}
$ReadDns = Get-Content $DsnPath
foreach ($str in $ReadDns) {$1=$str.contains("DRIVER") ; $2=$str.contains("SERVER") ; if($1 -eq $True) {$DataStoreFile = $Str} ElseIF ($2 -eq $True) {$DataStoreServer = $Str} }


# ---- General Summary Info ----
#Write-CustomOut "..Adding General Summary Info to the report"

$CommentsSet = $Comments
$Comments = $False
	
If ($Check_GeneralDetails -eq "TRUE")
{
$XenAppReport += Get-CustomHeader "General Details" ""
$XenAppReport += Get-HTMLDetail "Domain :" ($Domain)
$XenAppReport += Get-HTMLDetail "Farm version :" ($farm.ServerVersion)
$XenAppReport += Get-HTMLDetail "Datastore type" (@($DataStoreFile.Substring(7)))
$XenAppReport += Get-HTMLDetail "Datastore Server" (@($DataStoreServer.Substring(7)))
$XenAppReport += Get-HTMLDetail "Licence Server Name and port" (@($farmConf.LicenseServerName + " ("+$farmConf.LicenseServerPortNumber+")"))

#Find TS/RDS licence server on local server
$HKLM = 2147483650
$reg = [WMIClass] "\\.\root\default:StdRegProv"
$key = "SYSTEM\CurrentControlSet\Services\TermService\Parameters\LicenseServers\" 
$value = "LicenseServers" 
$RDSLicenceServer = $reg.EnumKey($HKLM, $key)
$XenAppReport += Get-HTMLDetail "TS/RDS licence server :" (@($RDSLicenceServer.snames))
	
$XenAppReport += Get-HTMLDetail "Number of Servers:" (@($Servers_Count))
$XenAppReport += Get-HTMLDetail "Number of Applications:" (@($Applications_Count))
$XenAppReport += Get-HTMLDetail "Number of Zones:" (@($Zones_Count))
$XenAppReport += Get-HTMLDetail "Number of Load Evaluators:" (@($LoadEvalutaror_Count))
$XenAppReport += Get-HTMLDetail "Number of Policy:" (@($Policy_Count))
$XenAppReport += Get-HTMLDetail "Number of Administrators:" (@($Adm_Count))
$XenAppReport += Get-CustomHeaderClose
}

If ($Check_DisplaySection -eq "TRUE")
{
$XenAppReport += Get-CustomHeader "Section(s) statut"
If ($Check_GeneralDetails -eq "FALSE") {$XenAppReport += Get-HTMLDetail "General Details :" ("Disable")}
If ($Check_DsCheckReport -eq "FALSE") {$XenAppReport += Get-HTMLDetail "Dscheck :" ("Disable")}
If ($Check_CmdletExecutionTime -eq "FALSE") {$XenAppReport += Get-HTMLDetail "Cmdlet execution time :" ("Disable")}
If ($Check_OutputEntetePolicyCompDisable -eq "FALSE") {$XenAppReport += Get-HTMLDetail "Zone :" ("Disable")}
If ($Check_OutputEntetePolicyCompDisable -eq "FALSE") {$XenAppReport += Get-HTMLDetail "Computer Policy :" ("Disable")}
If ($Check_OutputEntetePolicyUserDisable -eq "FALSE") {$XenAppReport += Get-HTMLDetail "User Policy :" ("Disable")}
If ($Check_VarOutputEnteteServ -eq "FALSE") {$XenAppReport += Get-HTMLDetail "3999 event (ZDC election) :" ("Disable")}
If ($Check_VarOutputEnteteServ -eq "FALSE") {$XenAppReport += Get-HTMLDetail "Service statut :" ("Disable")}
If ($Check_VarOutputServDisk -eq "FALSE") {$XenAppReport += Get-HTMLDetail "Disk space :" ("Disable")}
If ($Check_VarOuTputServLogon -eq "FALSE") {$XenAppReport += Get-HTMLDetail "Logon server :" ("Disable")}
If ($Check_VarOuTputLoadMaintenance -eq "FALSE") {$XenAppReport += Get-HTMLDetail "Server(s) in Load Evaluator :" ("Disable")}
If ($Check_VarFunctionApp_CountServer -eq "FALSE") {$XenAppReport += Get-HTMLDetail "Server in Application(s)" ("Disable")}
If ($Check_VarUptime -eq "FALSE") {$XenAppReport += Get-HTMLDetail "Uptime Server :" ("Disable")}
If ($Check_VarTypeSrv -eq "FALSE") {$XenAppReport += Get-HTMLDetail "Server(s) type :" ("Disable")}
If ($Check_EdgeSightAgentVer -eq "FALSE") {$XenAppReport += Get-HTMLDetail "EdgeSight agent version :" ("Disable")}
If ($Check_Ctx_HotFix -eq "FALSE") {$XenAppReport += Get-HTMLDetail "Citrix Hotfix missing :" ("Disable")}
If ($Check_Ctx_SrvLoad -eq "FALSE") {$XenAppReport += Get-HTMLDetail "Server(s) Load :" ("Disable")}
If ($Check_Ctx_UPMver -eq "FALSE") {$XenAppReport += Get-HTMLDetail "UPM version" ("Disable")}
$XenAppReport += Get-CustomHeaderClose	
}

	
#Write-CustomOut " DsCheck.Exe Adding result Dscheck to the report
If ($Check_DsCheckReport -eq "TRUE")
{
	If ($OSarchi -eq "32") {$DsCheckPath = "C:\Program Files\Citrix\System32\dscheck.exe"} else {$DsCheckPath = "C:\Program Files (x86)\Citrix\System32\dscheck.exe"}
	$XenAppReport += Get-CustomHeader ("DsCheck Details  <BR> ")
	$DsCheckReport =  & $DsCheckPath
			 
	   Foreach ($line in $DsCheckReport)
	   {
	   if($line -eq "") {} else {$DscheckLine += $line+"<br>"}
	   }
										  
	$XenAppReport += $DscheckLine
	$XenAppReport += Get-CustomHeaderClose
}

	
#Write-CustomOut " Cmdlet execution time result to the report
If ($Check_CmdletExecutionTime -eq "TRUE")
{
$FormatTime = "(hh:mm:ss)"
$XenAppReport += Get-CustomHeader ("Cmdlet Execution Time")
$OutputEnteteCmdletExecutionTime += @($ExecutionTimeXaFarm | Select @{N="Cmdlet";E={"Get-XAFarm"}}, @{N="Time execution $FormatTime";E={$ExecutionTimeXaFarm.retStr}})
$OutputEnteteCmdletExecutionTime += @($ExecutionTimeXaZone | Select @{N="Cmdlet";E={"Get-XAZone"}}, @{N="Time execution $FormatTime";E={$ExecutionTimeXaZone.retStr}})
$OutputEnteteCmdletExecutionTime += @($ExecutionTimeXaLE | Select @{N="Cmdlet";E={"Get-XALoadEvaluator"}}, @{N="Time execution $FormatTime";E={$ExecutionTimeXaLE.retStr}})
$OutputEnteteCmdletExecutionTime += @($ExecutionTimePolicy | Select @{N="Cmdlet";E={"Get-XAPolicy"}}, @{N="Time execution $FormatTime";E={$ExecutionTimePolicy.retStr}})
$OutputEnteteCmdletExecutionTime += @($ExecutionTimeXAAdministrator | Select @{N="Cmdlet";E={"Get-XAAdministrator"}}, @{N="Time execution $FormatTime";E={$ExecutionTimeXAAdministrator.retStr}})
$OutputEnteteCmdletExecutionTime += @($ExecutionTimeXAApplicationReport | Select @{N="Cmdlet";E={"Get-XAApplicationReport"}}, @{N="Time execution $FormatTime";E={$ExecutionTimeXAApplicationReport.retStr}})
$OutputEnteteCmdletExecutionTime += @($ExecutionTimeXAServer | Select @{N="Cmdlet";E={"Get-XAServer"}}, @{N="Time execution $FormatTime";E={$ExecutionTimeXAServer.retStr}})
$XenAppReport += Get-HTMLTable $OutputEnteteCmdletExecutionTime 
$XenAppReport += Get-CustomHeaderClose
}
	
	
	
#Write-CustomOut "..Adding Zones Details Info to the report"
If ($Check_OutputEnteteZone -eq "TRUE")
{
Foreach ($Zones in $Zones) {$OutputEnteteZone += @($Zones | Select @{N="Zone Name";E={if($Zones.ZoneName -eq $Null){"Error"}else{$Zones.ZoneName}}}, @{N="Zone Data Collector";E={if($Zones.DataCollector -eq $Null){"Error"}else{$Zones.DataCollector}}}) }
$XenAppReport += Get-CustomHeader ("Zone(s) Details : "+($Zones_Count))
$XenAppReport += Get-HTMLTable $OutputEnteteZone
$XenAppReport += Get-CustomHeaderClose
}


#Write-CustomOut "..Adding policy disabled to the report"
If ($Check_OutputEntetePolicyDisable -eq "TRUE")
{
	$OutputEntetePolicyDisable = @()
	Foreach ($Policy in $Policy)
	{
	$VarFunctionOutputEntetePolicyDisable = PolicyDisable
	$OutputEntetePolicyDisable += $VarFunctionOutputEntetePolicyDisable.PolicyDisableTab
	$PolicyDisableCount += $VarFunctionOutputEntetePolicyDisable.PolicyDisableCount 
	}

$XenAppReport += Get-CustomHeader ("Policy(s) Disable : " + $PolicyDisableCount)
$XenAppReport += Get-HTMLTable $OutputEntetePolicyDisable
$XenAppReport += Get-CustomHeaderClose
}
	
#Write-CustomOut "..Adding Servers Check Info to the report"
$OutputEnteteEvent4033 = @()
$OutputEnteteServ = @()
$OutputServDisk = @()
$OuTputServLogon = @()
$OuTputLoadMaintenance = @()
$OutputOffLineServer = @()
$OfflineServers = @()

#*********************************************************************************************
#Checks Server(s)
#*********************************************************************************************	
Write-host "Server(s) :"	
Foreach ($Server in $Servers)
{
		$ServFolder = $Server.FolderPath	
		if ($ServFolder | select-string -pattern $ServFolderExclude) {}
		Else
		{
			If($OnLineServers-match $Server.ServerName)
			{
			$oldpos = $host.ui.RawUI.CursorPosition ; write-Host $Server -ForegroundColor  yellow -nonewline
			
				#Check WMI
				$tcpobject = new-Object system.Net.Sockets.TcpClient 
				#Connect to remote machine's port               
				$connect = $tcpobject.BeginConnect($Server,$TcpPort,$null,$null) 
				#Configure a timeout before quitting - time in milliseconds 
				$wait = $connect.AsyncWaitHandle.WaitOne(1000,$false) 
				If (-Not $Wait)
				{
				$CountPortErr++
				Write-host " ------- $server TCP Port $TcpPort is closed" -F yellow
				$WmiError = 1
				$WmiTcpError +=  @($Server | Select @{n="Server(s)";e={$Server}},@{n="TCP port $TcpPort";e={"Error"}})
				}
				Else 
				{
				$WmiError = 0
				$error.clear()
				$tcpobject.EndConnect($connect) | out-Null 
				If ($Error[0]) {Write-warning ("{0}" -f $error[0].Exception.Message)}
				}
			
			
				#If $Check_VarFunctionEvent4033 is TRUE, The Event4033 is enable
				If ($Check_VarFunctionEvent4033 -eq "TRUE") 
				{
				#call Event4033 function
				$VarFunctionEvent4033 = Event4033
				$OutputEnteteEvent4033 += $VarFunctionEvent4033.Event4033Tab
				$4033Count += $VarFunctionEvent4033.Event4033Count
				}

				
				#If $Check_VarOutputEnteteServ is TRUE, The VarOutputEnteteServ is enable
				If ($Check_VarOutputEnteteServ -eq "TRUE")
				{
				#call TestingService Function
				$VarOutputEnteteServ = TestingService
				$OutputEnteteServ += $VarOutputEnteteServ.TestingServiceTab
				$TestServiceCount += $VarOutputEnteteServ.TestingServiceCount
				}
			
			
				#If $Check_VarOutputServDisk is TRUE, The VarOutputServDisk is enable
				If ($Check_VarOutputServDisk -eq "TRUE")
				{
				#call DiskSpace Function
				$VarOutputServDisk = DiskSpace
				$OutputServDisk += $VarOutputServDisk.DiskSpaceTab
				$DiSpaceCount += $VarOutputServDisk.DiskSpaceCount
				}
			
			
				#If $Check_VarOuTputServLogon is TRUE, The VarOuTputServLogon is enable
				If ($Check_VarOuTputServLogon -eq "TRUE")
				{	
				#call LogonDisabled Function
				$VarOuTputServLogon = LogonDisabled
				$OuTputServLogon += $VarOuTputServLogon.LogonDisabledTab
				$LogDisabledCount += $VarOuTputServLogon.LogonDisabledCount
				}
			
				#If $Check_VarOuTputLoadMaintenance is TRUE, The VarOuTputLoadMaintenance is enable
				If ($Check_VarOuTputLoadMaintenance -eq "TRUE")
				{	
				#call LoadMaintenance Function
				$VarOuTputLoadMaintenance = LoadMaintenance
				$OuTputLoadMaintenance += $VarOuTputLoadMaintenance.LoadMaintenanceTab
				$LoMaintenanceCount += $VarOuTputLoadMaintenance.LoadMaintenanceCount
				}
				
				#If $Check_VarUptime is TRUE, The Check_VarUptime is enable
				If ($Check_VarUptime -eq "TRUE")
				{
				#call TestingService Function
				$VarUptime = Uptime
				$OutputUptime += $VarUptime.UptimeTab
				$UptimeCount += $VarUptime.UptimeCount
				}
				
				#If $Check_VarTypeSrv is TRUE, The Check_VarTypeSrv is enable
				If ($Check_VarTypeSrv -eq "TRUE")
				{
				#call Hypervisor_type
				$VarOutputHypervisortype = HypervisorType
				$HypervisorTypeCountPhysical += $VarOutputHypervisortype.PhysicalCount
				$HypervisorTypeCountVm += $VarOutputHypervisortype.VmCount
				$HypervisorTypeCountXen += $VarOutputHypervisortype.XenCount
				$HypervisorTypeCountHyperV += $VarOutputHypervisortype.HyperVCount
				$HypervisorTypeCountError += $VarOutputHypervisortype.ErrorCount
								
				
				$HypervisorTypeCountPhysicalPercent = "{0:n2}" -f (($HypervisorTypeCountPhysical) * 100 / ($Servers_Count))
				$HypervisorTypeCountVmPercent = "{0:n2}" -f(($HypervisorTypeCountVm) * 100 / ($Servers_Count))
				$HypervisorTypeCountXenPercent = "{0:n2}" -f (($HypervisorTypeCountXen) * 100 / ($Servers_Count))
				$HypervisorTypeCountHyperVPercent = "{0:n2}" -f (($HypervisorTypeCountHyperV) * 100 / ($Servers_Count))
				$HypervisorTypeCountErrorPercent = "{0:n2}" -f (($HypervisorTypeCountError) * 100 / ($Servers_Count))
				}
				
				#If $Check_EdgeSightAgentVer is TRUE, The Check_EdgeSightAgentVer is enable
				If ($Check_EdgeSightAgentVer -eq "TRUE")
				{
				#call EdgeSightVersion Function
				$VarOutputEgeSightVersion = EdgeSightVersion
				$OutputEgeSightVersion += $VarOutputEgeSightVersion.EdgeSightTab
				$EdgeSightCount += $VarOutputEgeSightVersion.EdgeSightCount
				}
				
				#If $Check_Ctx_HotFix is TRUE, The Check_Ctx_HotFix is enable
				If ($Check_Ctx_HotFix -eq "TRUE")
				{
				#call Check_Ctx_HotFix Function
				$CtxHotFix = Ctx_HotFix
				$OutputCtxHotFix += $CtxHotFix.Ctx_HotFixTab
				$CtxHotFixCount += $CtxHotFix.Ctx_HotFixCount
				}
				
				#If $Check_Ctx_SrvLoad is TRUE, The Check_Ctx_SrvLoad is enable
				If ($Check_Ctx_SrvLoad -eq "TRUE")
				{
					if ($VarOuTputLoadMaintenance.LoadMaintenanceName -notmatch $LoadEval_Check)
					{
					#call Check_Ctx_HotFix Function
					$CtxSrvLoad = Ctx_SrvLoad
					$OutputCtxSrvLoad += $CtxSrvLoad.Ctx_SrvLoadTab
					$CtxSrvLoadCount += $CtxSrvLoad.Ctx_SrvLoadCount
					}
				}
				
				#If $Check_Ctx_UPMver is TRUE, The Check_Ctx_UPMver is enable
				If ($Check_Ctx_UPMver -eq "TRUE")
				{
				#call Check_Ctx_HotFix Function
				$CtxUPMVer = Ctx_UPMver
				$OutputCtxUPMVer += $CtxUPMVer.Ctx_UPMverTab
				$CtxUPMCount += $CtxUPMVer.Ctx_UPMCount
				}
				
				$host.ui.RawUI.CursorPosition = $oldpos ; write-Host $Server -ForegroundColor green 
				
			}
			else 
			{
			$OfflineServers += $Server.ServerName
			Write-host $Server.ServerName " Offline" -ForegroundColor red
			$OutputOffLineServer += @($Server | Select @{N="Server Name";E={$Server.ServerName}},@{N="Folder Path";E={$Server.FolderPath}}, @{N="Zone";E={$server.ZoneName}}	) 
			$OutputOffLineServerCount += 1
			}
		}
}

#*****************
#Build HTML report
#*****************
If ($Check_VarFunctionEvent4033 -eq "TRUE") 
{
$XenAppReport += Get-CustomHeader ("Event 4033 : " + $4033Count)
$XenAppReport += Get-HTMLTable $OutputEnteteEvent4033
$XenAppReport += Get-CustomHeaderClose
}

If ($Check_VarOutputEnteteServ -eq "TRUE")
{
$XenAppReport += Get-CustomHeader ("Error Service : " + $TestServiceCount)
$XenAppReport += Get-HTMLTable $OutputEnteteServ
$XenAppReport += Get-CustomHeaderClose
}

If ($Check_VarOutputServDisk -eq "TRUE")
{
$XenAppReport += Get-CustomHeader ("Disk Space <= $DiskMin Go : " + $DiSpaceCount)
$XenAppReport += Get-HTMLTable $OutputServDisk
$XenAppReport += Get-CustomHeaderClose
}

If ($Check_VarOuTputServLogon -eq "TRUE")
{	
$XenAppReport += Get-CustomHeader ("Logon Server(s) Disabled : "+ $LogDisabledCount)
$XenAppReport += Get-HTMLTable $OuTputServLogon
$XenAppReport += Get-CustomHeaderClose
}

If ($Check_VarOuTputLoadMaintenance -eq "TRUE")
{	
$XenAppReport += Get-CustomHeader ("Server(s) in Load Evaluator $LoadEval_Check : " + $LoMaintenanceCount)
$XenAppReport += Get-HTMLTable $OuTputLoadMaintenance
$XenAppReport += Get-CustomHeaderClose
}

If ($Check_VarUptime -eq "TRUE")
{	
$XenAppReport += Get-CustomHeader ("Uptime Servers =>$Uptime day(s) : "+ $UptimeCount)
$XenAppReport += Get-HTMLTable $OutputUptime
$XenAppReport += Get-CustomHeaderClose
}

If ($Check_VarTypeSrv -eq "TRUE")
{
$XenAppReport += Get-CustomHeader ("Server(s) type : " + $Hypervisor_typeCount)
$VarOutputHypervisorTypeVm += @($Server | Select  @{N="Type";E={"Physical"}}, @{N="Number Server";E={$HypervisorTypeCountPhysical}}, @{N="%";E={$HypervisorTypeCountPhysicalPercent}})
$VarOutputHypervisorTypeVm += @($Server | Select  @{N="Type";E={"VMware"}}, @{N="Number Server";E={$HypervisorTypeCountVm}}, @{N="%";E={$HypervisorTypeCountVmPercent}})
$VarOutputHypervisorTypeVm += @($Server | Select  @{N="Type";E={"Xen"}}, @{N="Number Server";E={$HypervisorTypeCountXen}}, @{N="%";E={$HypervisorTypeCountXenPercent}})
$VarOutputHypervisorTypeVm += @($Server | Select  @{N="Type";E={"Hyper-V"}}, @{N="Number Server";E={$HypervisorTypeCountHyperV}}, @{N="%";E={$HypervisorTypeCountHyperVPercent}})

if ($HypervisorTypeCountError -ge 1)
{
$VarOutputHypervisorTypeVm += @($Server | Select  @{N="Type";E={"Error"}}, @{N="Number Server";E={$HypervisorTypeCountError}}, @{N="%";E={$HypervisorTypeCountErrorPercent}})
}
$XenAppReport += Get-HTMLTable $VarOutputHypervisorTypeVm
$XenAppReport += Get-CustomHeaderClose
}

If ($Check_EdgeSightAgentVer -eq "TRUE")
{	
$XenAppReport += Get-CustomHeader ("EdgeSight agent version not match : $EdgeSightAgentRef : $EdgeSightCount")
$XenAppReport += Get-HTMLTable $OutputEgeSightVersion
$XenAppReport += Get-CustomHeaderClose
}

If ($Check_Ctx_HotFix -eq "TRUE")
{	
$XenAppReport += Get-CustomHeader ("Citrix Hotfix missing : $CtxHotFixCount")
$XenAppReport += Get-HTMLTable $OutputCtxHotFix
$XenAppReport += Get-CustomHeaderClose
}

If ($Check_Ctx_SrvLoad -eq "TRUE")
{	
$XenAppReport += Get-CustomHeader ("Server(s) Load  : $CtxSrvLoadCount")
$XenAppReport += Get-HTMLTable $OutputCtxSrvLoad
$XenAppReport += Get-CustomHeaderClose
}

If ($Check_Ctx_UPMver -eq "TRUE")
{	
$XenAppReport += Get-CustomHeader ("UPM version  not match $UPMver : $CtxUPMCount")
$XenAppReport += Get-HTMLTable $OutputCtxUPMVer
$XenAppReport += Get-CustomHeaderClose
}

	
$XenAppReport += Get-CustomHeader ("Server(s) Off line : " + $OutputOffLineServerCount)
$XenAppReport += Get-HTMLTable $OutputOffLineServer
$XenAppReport += Get-CustomHeaderClose
	
	

#Write-CustomOut "..Adding Applications Check Info to the  report"
$OuTputApp_Servers = @()
$OuTputApp_Disable = @()

Foreach ($Applications in $Applications) 
{
$AppFolder = $Applications.FolderPath
$AppName = $Applications.DisplayName
	if (($AppFolder | select-string -pattern $AppFolderExclude) -or ($AppName | select-string -pattern $AppNameExclude))  {}
	Else
	{

	#call App_CountServer function
		If ($Check_VarFunctionApp_CountServer -eq "TRUE")
		{
		$VarFunctionApp_CountServer = App_CountServer
		$OuTputApp_Server += $VarFunctionApp_CountServer.App_CountServerTab
		$AppCountServCount += $VarFunctionApp_CountServer.App_CountServerCount
		}
		
	#call App_Disable function
		If ($Check_VarFunctionApp_Disable -eq "TRUE")
		{
		$VarFunctionApp_Disable = App_Disable
		$OutputApp_Disable += $VarFunctionApp_Disable.App_DisableTab
		$AppDisabCount += $VarFunctionApp_Disable.App_DisableCount
		}
	}
}

If ($Check_VarFunctionApp_CountServers -eq "TRUE")
{
$XenAppReport += Get-CustomHeader ("Server in Application(s) <=1 server : " + $AppCountServCount )
$XenAppReport += Get-HTMLTable $OuTputApp_Servers 
$XenAppReport += Get-CustomHeaderClose
}


If ($Check_VarFunctionApp_Disable -eq "TRUE")
{
$XenAppReport += Get-CustomHeader ("Application(s) Disable : " + $AppDisabCount)
$XenAppReport += Get-HTMLTable $OuTputApp_Disable
$XenAppReport += Get-CustomHeaderClose
}
	
	
# ---- Time to build ----
$XenAppReport += Get-CustomHeader "Time to build"
$executiontime = (get-date) - $date
$XenAppReport += Get-HTMLDetail "Time in minute(s):" (@([math]::round($executiontime.TotalMinutes,2)))
$XenAppReport += Get-CustomHeaderClose
$XenAppReport += Get-CustomHeader0Close
$XenAppReport += Get-CustomHTMLClose


$Date = Get-Date -Format "yyyyMMddHH"
$FileXenApp_Check = $PathLog + $FileName + ".htm"
$FileXenApp_CheckBackup = $PathBackup + $FileName + "_" + $date + ".htm"


$XenAppReport | out-file -encoding ASCII -filepath $FileXenApp_Check
$XenAppReport | out-file -encoding ASCII -filepath $FileXenApp_CheckBackup


#Write-CustomOut "..Sending Email"
send-SMTPmail $EmailTo $EmailFrom "XenApp_Check $Farm" $SMTPSRV $XenAppReport